/*
  random numbers generator
  written by alexander yaworsky
  based on someone's source;
  i changed floating point operations to integer
  september '99
*/

//#define TEST

#include <windows.h>

#include "stdlib.h"
#include "switches.h"

#ifdef TEST
#  include <stdio.h>
#endif


static  int  i97, j97;
static  int  u[98];
static  int  c, cd, cm;

static void  RndInit( int ij, int kl )
/*
  This is the initialization routine for the random number generator.
  NOTE: The seed variables can have values between:    0 <= IJ <= 31328
                                                       0 <= KL <= 30081
  The random number sequences created by these two seeds are of sufficient
  length to complete an entire calculation with. For example, if sveral
  different groups are working on different parts of the same calculation,
  each group could be assigned its own IJ seed. This would leave each group
  with 30000 choices for the second seed. That is to say, this random
  number generator can create 900 million different subsequences -- with
  each subsequence having a length of approximately 10^30.

  Use IJ = 1802 & KL = 9373 to test the random number generator. The
  subroutine RndGet should be used to generate 20000 random numbers.
  Then display the next six random numbers generated multiplied by 4096*4096
  If the random number generator is working properly, the random numbers
  should be:
            6533892.0  14220222.0  7275067.0
            6172232.0  8354498.0   10633180.0
*/
  {
    int  s, t, i, j, k, l, ii, jj, m;

    ij %= 31329;
    kl %= 30082;

    i = (ij/177)%177 + 2;
    j = ij%177 + 2;
    k = (kl/169)%178 + 1;
    l = kl%169;

    for (ii=1; ii<=97; ii++) {
      s = 0;
      t = 0x800000;
      for (jj=1; jj<=24; jj++) {
        m = (((i*j)%179)*k) % 179;
        i = j;
        j = k;
        k = m;
        l = (53*l + 1) % 169;
        if ((l*m)%64 >= 32) s += t;
        t >>= 1;
      }
      u[ii] = s;
    }

    c = 362436;
    cd = 7654321;
    cm = 16777213;

    i97 = 97;
    j97 = 33;
  }


static int  Random()
  {
    int uni;

    uni = u[ i97 ] - u[ j97 ];
    if( uni < 0 ) uni += 0x1000000;
    u[ i97 ] = uni;
    i97--;
    if( i97 == 0 ) i97 = 97;
    j97--;
    if( j97 == 0 ) j97 = 97;
    c -= cd;
    if( c < 0 ) c += cm;
    uni -= c;
    if( uni < 0 ) uni += 0x1000000;
    return uni;
  }


static volatile LONG Flag = 0;
static volatile LONG Initialized = 0;


void Srand( ULONG seed )
  {
    while( InterlockedExchange( (LPLONG) &Flag, 1 ) != 0 ) Sleep(0);
    RndInit( GetTickCount() ^ 0x187C5A64, seed );
    Initialized = 1;
    InterlockedExchange( (LPLONG) &Flag, 0 );
  }

ULONG Rand()
  {
    ULONG  rc;

    while( InterlockedExchange( (LPLONG) &Flag, 1 ) != 0 ) Sleep(0);
    if( ! Initialized ) RndInit( 0x187C5A64, GetTickCount() ^ 0x75A847A5 );
    Initialized = 1;
    rc = Random();
    InterlockedExchange( (LPLONG) &Flag, 0 );
    return rc;
  }


#ifdef TEST

void main()
  {
    int  i;

    RndInit( 1802, 9373 );
    for(i = 0; i < 20000; i++ ) Random();
    for(i = 0; i < 6; i++ ) printf( "%d ", Random() );
    puts("");

    Srand(0);
    for(;;) {
      printf( "%d\r", Rand() );
      gets("     ");
    }
  }

#endif
